<?php
// ++=========================================================================++
// || vBadvanced CMPS v3.2.0 (vB 3.6 - vB 3.8) - 107361
// ||  2003-2009 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// || Downloaded 19:13, Thu Jun 4th 2009
// || 880107361_406221041574
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);

// ##### Order Navigation Module Links ########################################
function order_nav($a, $b)
{
	return ($a['order'] < $b['order']) ? -1 : 1;
}

// ##### Update Module Cache ##################################################
function update_module_cache()
{
	global $db;

	$module = array();
	$mods = $db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "adv_modules
		WHERE active = 1
		ORDER BY title, modid
	");
	while ($mod = $db->fetch_array($mods))
	{
		$mod['userperms'] = explode(',', $mod['userperms']);
		$mod['templatelist'] = explode("\r\n", $mod['templatelist']);

		// No need for the unparsed bb code to be stored
		if ($mod['inctype'] == 'bb_code')
		{
			$mod['filename'] = '';
		}

		($hook = vBulletinHook::fetch_hook('vba_cmps_modulecache_loop')) ? eval($hook) : false;

		$module[$mod['modid']] = $mod;
	}
	build_datastore('adv_modules', serialize($module), 1);
}

// ##### Update Page Cache ####################################################
function update_page_cache()
{
	global $db;

	$extrafields = '';
	($hook = vBulletinHook::fetch_hook('vba_cmps_pagecache_start')) ? eval($hook) : false;

	$pagecache = array();
	$getpages = $db->query_read("
		SELECT pageid, title, name, parentid, userperms
		$extrafields
		FROM " . TABLE_PREFIX . "adv_pages
		WHERE active = 1 ORDER BY displayorder
	");
	while ($page = $db->fetch_array($getpages))
	{
		$page['userperms'] = explode(',', $page['userperms']);

		($hook = vBulletinHook::fetch_hook('vba_cmps_pagecache_loop')) ? eval($hook) : false;
		$pagecache[$page['pageid']] = $page;
	}

	$db->free_result($getpages);
	unset($page);

	$pagecache = construct_page_structure($pagecache);

	build_datastore('adv_portal_page', iif(!empty($pagecache), serialize($pagecache)), 1);
}

// ##### Update Homepage Cache ################################################
function update_homepage_cache()
{
	global $db;

	$page = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "adv_pages WHERE name = 'home'");
	$page['advanced'] = unserialize($page['advanced']);
	$page['meta'] = unserialize($page['meta']);
	$page['userperms'] = explode(',', $page['userperms']);
	$page['modules'] = unserialize($page['modules']);

	($hook = vBulletinHook::fetch_hook('vba_cmps_homepagecache')) ? eval($hook) : false;

	build_datastore('adv_portal_home', serialize($page), 1);

	build_datastore(
		'adv_portal_pars',
		serialize(array('home' => array(), 'lastupdate' => 0)),
		1
	);
}

// ##### Build Settings #######################################################
function build_adv_settings()
{
	global $db;

	$vba_options = array();
	$settings = $db->query_read("
		SELECT varname, value, grouptitle, serialize
		FROM " . TABLE_PREFIX . "adv_setting
		WHERE grouptitle LIKE 'adv_portal%'
			OR grouptitle = 'adv_global'
	");
	while ($setting = $db->fetch_array($settings))
	{
		if ($setting['serialize'])
		{
			$setting['value'] = unserialize($setting['value']);
			
			if (!is_array($setting['value']))
			{
				$setting['value'] = array();
			}
		}

		($hook = vBulletinHook::fetch_hook('vba_cmps_settingscache_loop')) ? eval($hook) : false;

		$vba_options[$setting['grouptitle']][$setting['varname']] = $setting['value'];
	}

	$db->free_result($settings);
	build_datastore('adv_portal_opts', serialize($vba_options), 1);
}

// ##### Rebuild Parents ######################################################
function rebuild_parents($pageid = 0)
{
	global $db, $parentlist;

	$pages = array();

	$getpages = $db->query_read("SELECT pageid, parentid FROM " . TABLE_PREFIX . "adv_pages ORDER BY parentid");
	while ($pageinfo = $db->fetch_array($getpages))
	{
		$pages[] = $pageinfo;
	}

	$db->free_result($getpages);
	unset($pageinfo);

	foreach($pages AS $page)
	{
		if ($pageid != 0 AND $page['pageid'] != $pageid)
		{
			continue;
		}
		$parentlist = array();
		$parentlist[] = $page['pageid'];
		construct_parents($pages, $page['parentid']);
		$plist = implode(',', $parentlist);

		$db->query_write("UPDATE " . TABLE_PREFIX . "adv_pages SET parentlist = '$plist' WHERE pageid = '$page[pageid]'");
	}
}

// ##### Construct Parents ####################################################
function construct_parents($pageinfo, $pageid)
{
	global $parentlist;

	foreach ($pageinfo AS $pages)
	{
		if ($pages['pageid'] == $pageid)
		{
			$parentlist[] = $pages['pageid'];
			construct_parents($pageinfo, $pages['parentid']);
		}
	}
	return $parentlist;
}

// ##### Fetch Settings Phrases ###############################################
function fetch_settings_phrases()
{
	global $db;

	$return = array();
	$getphrases = $db->query_read("
		SELECT varname, text
		FROM " . TABLE_PREFIX . "phrase
		WHERE fieldname = 'vbsettings'
		ORDER BY languageid ASC
	");
	while($phrase = $db->fetch_array($getphrases))
	{
		$return[$phrase['varname']] = $phrase['text'];
	}

	return $return;
}

// ##### Fetch Column Phrases #################################################
function fetch_column_phrases($colarray)
{
	global $db;

	if (empty($colarray))
	{
		return array();
	}

	$colphrase = array();
	$getphrases = $db->query_read("
		SELECT varname, text
		FROM " . TABLE_PREFIX . "phrase
		WHERE varname IN('" . implode("_column', '", $colarray) . "_column')
			AND fieldname = 'adv_portal_cp'
			AND languageid IN(-1, 0)
		ORDER BY languageid ASC
	");
	while ($cphrases = $db->fetch_array($getphrases))
	{
		$colphrase[$cphrases['varname']] = $cphrases['text'];
	}

	return $colphrase;
}

// ##### Print Settings #######################################################
function print_adv_setting_group($type, $grouptitles = array(), $getpagesettings = true)
{
	global $db, $vbulletin, $vbphrase, $settingphrase, $stylevar, $page, $module, $modtitles, $settingscache;

	global $setting, $description, $name; // globalize for the vba_dyna_print_setting() function

	if (empty($settingphrase))
	{
		$settingphrase = fetch_settings_phrases();
	}

	$dyna_instances = array();

	// Moudle or page?
	switch ($type)
	{
		case 'module':
			$grouptitles = array('adv_portal_' . $module['identifier']);
			$modtitles = array('adv_portal_' . $module['identifier'] => $module['title']);
			$settingphrase['settinggroup_adv_portal_' . $module['identifier']] = construct_phrase($vbphrase['x_options'], $module['title']);

			if ($module['dyna_prefix'])
			{
				$dyna_instances = array('adv_portal_' . $module['identifier'] => $module['dyna_prefix']);
			}

		break;

		case 'page':
			$getpagesettings = false;

			// Figure out which modules we need
			$moduleident = array();
			$modsettings = array();
			foreach ($vbulletin->adv_modules AS $modkey => $module)
			{
				if ($module['identifier'])
				{
					$moduleident['adv_portal_' . $module['identifier']] = $module['modid'];

					if ($module['dyna_prefix'])
					{
						$dyna_instances['adv_portal_' . $module['identifier']] = $module['dyna_prefix'];
					}
				}
			}

			$excludegroups = '';
			if (!empty($moduleident))
			{
				$excludegroups = "AND grouptitle NOT IN('" . implode("', '", array_keys($moduleident)) . "')";
			}

			// ##### Get normal settinggroups
			$groups = $db->query_read("
				SELECT grouptitle
				FROM " . TABLE_PREFIX . "adv_settinggroup
				WHERE grouptitle LIKE 'adv_portal%'
					$excludegroups
				ORDER BY displayorder
			");
			while ($group = $db->fetch_array($groups))
			{
				$grouptitles[] = $group['grouptitle'];
			}

			// ##### Module settings
			if (!empty($moduleident))
			{
				$gettitles = $db->query_read("
					SELECT grouptitle
					FROM " . TABLE_PREFIX . "adv_setting
					WHERE grouptitle IN('" . implode("', '", array_keys($moduleident)) . "')
				");
				while ($titles = $db->fetch_array($gettitles))
				{
					$modsettings[] = $moduleident[$titles['grouptitle']];
				}

				// Just query them here to easily order by title
				if (!empty($modsettings))
				{
					$modules = $db->query_read("
						SELECT title, identifier
						FROM " . TABLE_PREFIX . "adv_modules AS module
						WHERE modid IN(" . implode(',', array_unique($modsettings)) . ")
						ORDER BY title
					");
					while ($module = $db->fetch_array($modules))
					{
						$gtitle = 'adv_portal_' . $module['identifier'];
						$settingphrase['settinggroup_' . $gtitle] = construct_phrase($vbphrase['x_options'], $module['title']);
						$grouptitles[] = $gtitle;
						$modulegroups[] = $gtitle;
						$modtitles['adv_portal_' . $module['identifier']] = $module['title'];
					}
				}
			}

		break;
		
		// main
		default:
		
			// Find Dynamics modules
			foreach ($vbulletin->adv_modules AS $modkey => $module)
			{
				if ($module['identifier'] AND $module['dyna_prefix'])
				{
					$dyna_instances['adv_portal_' . $module['identifier']] = $module['dyna_prefix'];
				}
			}
	}

	if (empty($grouptitles))
	{
		return;
	}

	$dyna_groups = array_keys($dyna_instances);
	$dyna_cache = array();
	if (!empty($dyna_instances))
	{
		require_once(DIR . '/includes/vba_dyna_adminfunctions_settings.php');
		
		$dyna_datastore = '';
		foreach (array_unique(array_values($dyna_instances)) AS $dynamod)
		{
			$dyna_datastore .= ($dyna_datastore ? "', '" : "'") . $dynamod . '_' . implode("', '". $dynamod . '_', $dyna_specialtemps);
		}
		$dyna_datastore .= "'";

		$dyna_datastore = $db->query_read("
			SELECT title, data, unserialize
			FROM " . TABLE_PREFIX . "datastore
			WHERE title IN($dyna_datastore)
		");
		while ($ddstore = $db->fetch_array($dyna_datastore))
		{
			$dyna_cache[$ddstore['title']] = ($ddstore['unserialize']) ? unserialize($ddstore['data']) : $ddstore['data'];
		}
	}

	// Get settings for each page
	$pagesettings = array();
	if ($getpagesettings)
	{
		$getpagesettings = $db->query_read("
			SELECT pageid, title, advanced
			FROM " . TABLE_PREFIX . "adv_pages
			WHERE advanced != ''
		");
		while ($psetting = $db->fetch_array($getpagesettings))
		{
			$psetting['advanced'] = unserialize($psetting['advanced']);

			if (!empty($psetting['advanced']))
			{
				foreach ($psetting['advanced'] AS $pgroup => $psettings)
				{
					foreach ($psettings AS $vname => $settings)
					{
						$pagesettings[$pgroup][$vname][$psetting['pageid']] = $psetting['title']	;
					}
				}
			}
		}

		$db->free_result($getpagesettings);
		unset($psetting);
	}

	// ##### Get the settings cache
	$settingscache = array();
	$settings = $db->query_read("
		SELECT adv_setting.*
		FROM " . TABLE_PREFIX . "adv_setting AS adv_setting
		LEFT JOIN " . TABLE_PREFIX . "adv_settinggroup AS adv_settinggroup ON (adv_setting.grouptitle = adv_settinggroup.grouptitle)
		WHERE optioncode != 'hidden'
			AND adv_setting.grouptitle IN('" . implode("', '", $grouptitles) . "')
			" . iif($type == 'page', "AND varname NOT IN('portal_pagevar', 'portal_column_array') AND adv_setting.grouptitle != 'adv_portal_admin'") . "
		ORDER BY adv_settinggroup.displayorder, adv_setting.displayorder
	");

	while ($setting = $db->fetch_array($settings))
	{
		if ($setting['serialize'])
		{
			$setting['value'] = unserialize($setting['value']);
			if (!is_array($setting['value']))
			{
				$setting['value'] = array();
			}
		}

		$settingscache[$setting['grouptitle']][$setting['varname']] = $setting;
	}

	$db->free_result($settings);
	unset($setting);

	// Number of custom page settings
	$customgroupcount = array();
	if ($type == 'page')
	{
		if (!empty($page['advanced']))
		{
			foreach ($page['advanced'] AS $page_group => $page_opts)
			{
				if (is_array($page_opts))
				{
					foreach ($page_opts AS $page_var => $page_value)
					{
						$customgroupcount[$page_group]++;
						$settingscache[$page_group][$page_var]['value'] = $page_value;
						$settingscache[$page_group][$page_var]['revert'] = true;
					}
				}
			}
		}
	}

	// Find settings with threadids
	$threadids = array();
	$threadgroups = array();
	if (!empty($settingscache))
	{
		foreach ($settingscache AS $gtitle => $gtsettings)
		{
			$tarray =& $gtsettings['portal_threadids']['value'];

			if (!empty($tarray) AND is_array($tarray))
			{
				foreach ($tarray AS $threadid => $postid)
				{
					$threadids[] = $threadid;
					$threadgroups[$threadid][] = $gtitle;
				}
			}
		}
	}

	// Get info for threadselect options
	$groupthreads = array();
	if (!empty($threadids))
	{
		$threads = $db->query_read("
			SELECT threadid, title
			FROM " . TABLE_PREFIX . "thread
			WHERE threadid IN(" . implode(',', $threadids) . ")
			ORDER BY lastpost DESC
		");
		while ($thread = $db->fetch_array($threads))
		{
			foreach ($threadgroups[$thread['threadid']] AS $tgroup)
			{
				$groupthreads[$tgroup][$thread['threadid']] = $thread['title'];
			}
		}
	}

	if (empty($moduleident))
	{
		$modgroups = array();
	}
	else
	{
		$modgroups = array_keys($moduleident);
	}

	$moduleprinted = (sizeof($settingscache) > 1 AND $type != 'page') ? false : true;

	?>

	<script type="text/javascript" language="javascript">
	<!--
		var i = 1;
		function add_input_field(inputname, grouptitle, locsetting)
		{
			var tbody = document.getElementById('moreinputs_' + grouptitle);
			var numi = document.getElementById('theValue_' + grouptitle);
			var num = (document.getElementById('theValue_' + grouptitle).value -1)+ 2;
			numi.value = num;

			inputtitle = '<?php print(($vbulletin->debug ? 'title="\' + inputname + \'[\' + num + \']" ' : '')); ?>';
			inputstart = '<input class="bginput" value="" tabindex="1" ' + inputtitle + 'name="' + inputname + '[' + num + ']';

			var row = document.createElement("TR");

			if (locsetting)
			{
				var td1 = document.createElement("TD");
				td1.innerHTML = inputstart + '[varname]" size="12" />';
				row.appendChild(td1);
	
				var td2 = document.createElement("TD")
				td2.innerHTML = inputstart + '[title]" size="16" />';
				row.appendChild(td2);
			}
			else
			{
				var td1 = document.createElement("TD");
				td1.innerHTML = inputstart + '[order]" size="2" />';
				row.appendChild(td1);
	
				var td2 = document.createElement("TD")
				td2.innerHTML = inputstart + '[level]" size="2" />';
				row.appendChild(td2);

				var td3 = document.createElement("TD")
				td3.innerHTML = inputstart + '[link]" size="26" />';
				row.appendChild(td3);

				var td4 = document.createElement("TD")
				td4.innerHTML = inputstart + '[text]" size="18" />';
				row.appendChild(td4);
			}

			tbody.appendChild(row);
		}
	-->
	</script>

	<style>
	<!--
	.cus_setting_msg	{
		padding: 6px 4px 6px 4px;
	}
	.cus_setting_box {
		margin-top:4px;
		padding: 4px;
		color: #000000;
		background-color:#FFFFFF;
		border: solid #FF0000 1px;
		width: 90%;
		font-size: 11px;
		font-weight: bold;
	}
	-->
	</style>
	<?php

	foreach ($grouptitles AS $grouptitle)
	{
		if (empty($settingscache[$grouptitle]))
		{
			continue;
		}

		$identifier = substr($grouptitle, 11);

		$collapsed = '';
		$display = '';

		if ($type == 'page' AND ($identifier != $_REQUEST['expandgroup'] OR !$_REQUEST['expandgroup']))
		{
			$collapsed = '_collapsed';
			$display = 'display: none';
		}

		// Print break for module options when viewing all settings
		if (!$moduleprinted)
		{
			if (in_array($grouptitle, $modgroups))
			{
				print_table_break();
				print_table_break();
				print_table_break();
				print_table_header(construct_phrase($vbphrase['x_options'], $vbphrase['vbadvanced_cmps'] . ' ' . $vbphrase['module']));
				print_table_break();
				$moduleprinted = true;
			}
		}

		echo '<table cellpadding="4" cellspacing="0" border="0" align="center" width="90%" class="tborder">
			<thead>
				<tr>';

		if ($type == 'page')
		{
			echo '<td class="thead" colspan="2" valign="top">
				<a href="#top" onclick="return toggle_collapse(\'sgroup_' . $grouptitle . '\')"><img alt="" border="0" id="collapseimg_sgroup_' . $grouptitle . '" src="../images/misc/vba_cp' . $collapsed . '.gif" /></a>&nbsp;&nbsp;' . $settingphrase['settinggroup_' . $grouptitle] .
				iif($customgroupcount[$grouptitle],
					'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;(' . construct_phrase(
						$vbphrase['x_settings_customized_for_this_page'],
						$customgroupcount[$grouptitle]
					) . ')'
				);
		}
		else
		{
			echo '<td class="tcat" colspan="2" align="center">
				<strong>' . $settingphrase['settinggroup_' . $grouptitle] . '</strong>' .
				iif($vbulletin->debug,
					'<span class="normal">' . construct_link_code($vbphrase['add_setting'], "vba_cmps_admin.php?$session[sessionurl]do=addsetting&amp;identifier=$identifier&amp;modid=$module[modid]") . '</span>');
		}

		echo '<a name="sgroup_' . $grouptitle . '"></td></tr></thead><tbody id="collapseobj_sgroup_' . $grouptitle . '" style="' . $display . '">';

		if (!empty($customgroupcount[$grouptitle]))
		{
			print_description_row('<div class="cus_setting_msg"><strong>' . $vbphrase['settings_customized_marked_with_asterisk'] . '</strong></div>', false, 2, 'tfoot');
		}

		$dyna_setting = false;
		if (in_array($grouptitle, $dyna_groups))
		{
			$dyna_setting = true;
			
			foreach ($dyna_specialtemps AS $dyna_temp)
			{
				$dyna_prefix = 'adv_dyna_' . $dyna_temp;
				$vbulletin->$dyna_prefix = $dyna_cache[$dyna_instances[$grouptitle] . '_' . $dyna_temp];
			}
		}

		foreach ($settingscache[$grouptitle] AS $settingid => $setting)
		{
			$jsdefault = '';
			$jsdefault_onclick = '';

			if ($type == 'page')
			{
				$jsdefault = 'js_check_default(\'' . $grouptitle . '\', \'' . $setting['varname'] . '\');';
				$jsdefault_onclick = 'onclick="' . $jsdefault . '"';
				$jsdefault_onchange = 'onchange="' . $jsdefault . '"';

				if ($setting['revert'])
				{
					$setting['asterisk'] = ' * ';
				}
				else
				{
					$setting['checked'] = ' checked="checked"';
				}
			}

			$settinglink = 'vba_cmps_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'varname=' . $setting['varname'] . '&amp;identifier=' . $identifier . '&amp;modid=' . $module['modid'];

			print_description_row(
				'<span class="smallfont" style="float:' . $stylevar['right'] . '">' .
					iif($vbulletin->debug AND $type != 'page',
						construct_link_code(
							$vbphrase['edit'],
							$settinglink . '&amp;do=editsetting'
						) .
						construct_link_code(
							$vbphrase['delete'],
							$settinglink . '&amp;do=removesetting'
						)
					) .
					' ' .
					iif($type == 'page',
						'<label for="' . $grouptitle . '_' . $setting['varname'] . '">' . $vbphrase['use_default'] . '</label>
						 <input' . $setting['checked'] . ' id="' . $grouptitle . '_' . $setting['varname'] . '" type="checkbox" name="usedefault[' . $grouptitle . '][' . $setting['varname'] . ']" value="1" />') .
					'</span>' . $setting['asterisk'] . iif($setting['optioncode'] == 'threadselect', $modtitles[$grouptitle] . ' ') . $settingphrase['setting_' . $setting['varname'] . '_title'] . '<a name="' . $setting['varname'] . '"></a>',
				0, 2, 'optiontitle" title="$vba_options[' . $setting['varname'] . ']"'
			);

			$description = '<div class="smallfont" title="$vba_options[' . $setting['varname'] . ']">' . $settingphrase['setting_' . $setting['varname'] . '_desc'] . '</div>';

			if (!empty($pagesettings[$grouptitle][$setting['varname']]))
			{
				$description .= '<div class="cus_setting_box">
					<strong>' . $vbphrase['setting_customized_pages'] . '</strong>
					<div style="padding-top: 4px">
						<select name="pageid" class="bginput" tabindex="1980">
							<option value="0">' . construct_phrase($vbphrase['x_pages'], sizeof($pagesettings[$grouptitle][$setting['varname']])) . '</option>
							<optgroup label="----------">';

				foreach ($pagesettings[$grouptitle][$setting['varname']] AS $spageid => $pagetitle)
				{
					$description .= '<option value="' . $spageid . '">' . $pagetitle . '</option>';
				}
				$description .= '</optgroup></select><div class="smallfont">' . $vbphrase['setting_customized_pages_desc'] . '</div></div></div>';
			}

			$name = 'setting[' . $grouptitle . '][' . $setting['varname'] . ']';

			// Dynamics setting
			if ($dyna_setting)
			{
				vba_dyna_print_setting($setting);
			}
			// CMPS setting
			else
			{
				switch ($setting['optioncode'])
				{
					// Text input
					case '':
						print_input_row($description, $name, $setting['value'], 1, 40, '', '', iif($type == 'page', 'bginput" onchange="' . $jsdefault));
					break;
	
					// Textarea
					case 'textarea':
						print_textarea_row($description, $name, $setting['value'], 8, 40, '', '', '', iif($type == 'page', 'bginput" onchange="' . $jsdefault));
					break;
	
					// Yes / No row
					case 'yesno':
						print_yes_no_row($description, $name, $setting['value'], $jsdefault);
					break;
	
					// Forum select box
					case 'forumselect':
					case 'forumselect_random':
	
						if (!is_array($setting['value']))
						{
							$setting['value'] = array();
						}
	
						$selectbox = '<select name="' . $name . '[]" ' . $jsdefault_onchange . ' multiple="multiple" style="width:275px" size="' . iif(sizeof($vbulletin->forumcache) > 10, 10, sizeof($vbulletin->forumcache)) . '" class="bginput" tabindex="1">';
	
						$optgroup = false;
						foreach ($vbulletin->forumcache AS $forum)
						{
							if (!($forum['options'] & $vbulletin->bf_misc_forumoptions['cancontainthreads']))
							{
								if ($optgroup)
								{
									$selectbox .= '</optgroup>';
								}
	
								$selectbox .= '<optgroup label="' . $forum['title'] . '">';
	
								$optgroup = true;
							}
							else
							{
								$selectbox .= '<option value="' . $forum['forumid'] . '" ' . iif(in_array($forum['forumid'], $setting['value']), 'selected="selected"') . '>' . str_repeat('--', $forum['depth']) . $forum['title'] . '</option>';
							}
						}
	
						if ($optgroup)
						{
							$selectbox .= '</optgroup>';
						}
	
						$selectbox .= '</select>';
	
						print_label_row($description, $selectbox);
	
					break;
	
					// Calendar select box
					case 'calendarselect':
						$selectbox = '<select name="' . $name . '" class="bginput" ' . $jsdefault_onchange . ' tabindex="1">';
						$selectbox .= '<option value="-1">' . $vbphrase['simple_calendar'] . '</option>';
						$getcalendars = $db->query_read("SELECT calendarid, title FROM " . TABLE_PREFIX . "calendar");
						while ($calendar = $db->fetch_array($getcalendars))
						{
							$selectbox .= '<option ' . iif($calendar['calendarid'] == $setting['value'], 'selected="selected"') . ' value="' . $calendar['calendarid']. '">' . $calendar['title'] . '</option>';
						}
						$selectbox .= '</select>';
	
						print_label_row($description, $selectbox);
					break;
	
					// Thread select link
					case 'threadselect':
					
						$maxthreads = 10;
						$right = '';
						$more = '';
	
						if (!empty($groupthreads[$grouptitle]))
						{
							$threadcount = sizeof($groupthreads[$grouptitle]);
							if ($threadcount > $maxthreads)
							{
								$groupthreads[$grouptitle] = array_slice($groupthreads[$grouptitle], 0, $maxthreads);
							}
							
							foreach ($groupthreads[$grouptitle] AS $threadid => $threadtitle)
							{
								$right .= '<div class="smallfont"><a href="' . $vbulletin->options['bburl'] . '/showthread.php?t=' . $threadid . '">' . fetch_trimmed_title($threadtitle, 50) . '</a></div>';
							}
							
							if ($threadcount > $maxthreads)
							{
								$right .= '<div class="smallfont" style="padding-top: 4px">(' . construct_phrase($vbphrase['x_total_threads'], $threadcount) . ')</div>';
							}
						}
	
						$right .= '<div class="smallfont" style="padding-top:8px"><a href="vba_cmps_admin.php?do=listforums&amp;identifier=' . $identifier . '&amp;pageid=' . iif($_REQUEST['do'] == 'addpage' OR $_REQUEST['do'] == 'copypage', 'newpage', $vbulletin->GPC['pageid']) . '" target="_blank" ' . $jsdefault_onclick . '><b>' . $vbphrase['edit_threads'] . '</b></a></div>';
	
						print_label_row($description, $right, '', 'top', $name);
					break;
	
					// Location Inputs
					case 'location_input':
	
						$colphrases = fetch_column_phrases(array_values($setting['value']));
	
						$colselect = '<table width="100%" cellpadding="2" cellspacing="0" class="tborder">
							<tbody id="moreinputs_' . $grouptitle . '">
							<tr>
								<td class="thead">' . $vbphrase['varname'] . '</td>
								<td class="thead">' . $vbphrase['title'] . '</td>
							</tr>';

						$nextcolval = (is_array($setting['value']) AND !empty($setting['value'])) ? max(array_keys($setting['value'])) + 1 : 0;

						$setting['value'][$nextcolval] = '';
						$setting['value'][$nextcolval + 1] = '';
	
						if (!empty($setting['value']))
						{
							foreach ($setting['value'] AS $colint => $colvar)
							{
								$colselect .= '<tr>
									<td><input type="text" size="12" name="' . $name . '[' . $colint . '][varname]" value="' . $colvar . '" class="bginput" tabindex="1"/></td>
									<td><input type="text" size="16" name="' . $name . '[' . $colint . '][title]" value="' . $colphrases[$colvar . '_column'] . '" class="bginput" tabindex="1" /></td>
								</tr>';
							}
						}
	
						$colselect .= '</tbody>
						<tr><td colspan="2"><input type="hidden" value="' . ($nextcolval + 2) . '" id="theValue_' . $grouptitle . '" />
							<div id="moreinputs_' . $grouptitle . '"> </div>
							<div style="padding: 4px">[<a href="javascript:;" onclick="add_input_field(\'' . $name . '\', \'' . $grouptitle . '\', 1)">' . $vbphrase['add_more'] . '</a>]</div></td>
						</tr></table>';
	
						print_label_row($description, $colselect);
	
					break;
	
					// Page select box
					case 'pageselect':
						$pagecache = cache_cmps_pages();
	
						$pageselect = array();
						foreach ($pagecache AS $pid => $pinfo)
						{
							$pageselect[$pid] = str_repeat('- - ', ($pinfo['level'] - 1)) . $pinfo['title'];
						}
	
						$selectbox = '<select name="' . $name . '[]" class="bginput" ' . $jsdefault_onchange . ' multiple="multiple" style="width:275px" size="' . iif(sizeof($pageselect) > 10, 10, sizeof($pageselect)) . '" tabindex="1">';
	
						foreach ($pagecache AS $spageid => $page)
						{
							$selectbox .= '<option value="' . $page['pageid'] . '" ' . iif(in_array($spageid, $setting['value']), 'selected="selected"') . '>' . str_repeat('--', $page['level']) . $page['title'] . '</option>';
						}
						$selectbox .= '</select>';
	
						print_label_row($description, $selectbox);
					break;
	
					// Additional page inputs
					case 'pageselect_add':
	
						$pagecount = 0;

						$nextcolval = (!empty($setting['value'])) ? max(array_keys($setting['value'])) + 1 : 0;

						// set empty inputs					
						$setting['value'][$nextcolval] = array();
						$setting['value'][$nextcolval + 1] = array();
						$setting['value'][$nextcolval + 2] = array();

						$inputs = '';
						if (!empty($setting['value']))
						{
							foreach ($setting['value'] AS $key => $navlinks)
							{
								$pagecount++;
								$inputs .= '<tr>
									<td><input class="bginput" name="' . $name . '[' . $pagecount . '][order]" value="' . $navlinks['order'] . '" size="2" tabindex="1" ' . $jsdefault_onchange . '/></td>
									<td><input class="bginput" name="' . $name . '[' . $pagecount . '][level]" value="' . $navlinks['level'] . '" size="2" tabindex="1" ' . $jsdefault_onchange . '/></td>
									<td><input class="bginput" name="' . $name . '[' . $pagecount . '][link]" value="' . $navlinks['link'] . '" size="26" tabindex="1" ' . $jsdefault_onchange . '/></td>
									<td><input class="bginput" name="' . $name . '[' . $pagecount . '][text]" value="' . htmlspecialchars($navlinks['text']) . '" size="18" tabindex="1" ' . $jsdefault_onchange . '/></td>
								</tr>';
							}
						}
	
						print_label_row($description, '
							<table align="right" cellpadding="2" cellspacing="0" class="tborder">
								<tr>
									<td class="thead">' . $vbphrase['order'] . '</td>
									<td class="thead">' . $vbphrase['level'] . '</td>
									<td class="thead">' . $vbphrase['link'] . '</td>
									<td class="thead">' . $vbphrase['text'] . '</td>
								</tr>
								<tbody id="moreinputs_' . $grouptitle . '">' .
								$inputs .
								'</tbody>
								<tr>
									<td colspan="4"><input type="hidden" value="' . $pagecount . '" id="theValue_' . $grouptitle . '" />
										<div id="moreinputs_' . $grouptitle . '"> </div>
										<div style="padding: 4px">[<a href="javascript:;" onclick="add_input_field(\'' . $name . '\', \'' . $grouptitle . '\')">' . $vbphrase['add_more'] . '</a>]</div>
									</td>
								</tr>
							</table>');
					break;
	
					// Default label row
					default:
	
						($hook = vBulletinHook::fetch_hook('vba_cmps_print_settingsbit')) ? eval($hook) : false;
	
						eval("\$right = \"$setting[optioncode]\";");
						print_label_row($description, $right, '', 'top', $name);
				}
			}
		}

		if ($type == 'module' OR sizeof($grouptitles) > 1)
		{
			print_middle_submit_row();
		}

		echo '</tbody>';

		if ($type == 'page')
		{
			echo '</table><div style="padding:4px"></div>';
			print_table_start(false);
		}
		else
		{
			print_table_break();
		}
	}
}

// ############################ Construct Settings ############################
function construct_cmps_settings($type = 'main')
{
	global $vbulletin, $db, $setting, $module;

	if (empty($setting))
	{
		return;
	}

	$adv_setting = array();

	$gtitlearray = array_keys($setting);

	// Get the old values
	$oldsettings = $db->query_read("
		SELECT varname, value, grouptitle, serialize
		FROM " . TABLE_PREFIX . "adv_setting
		WHERE grouptitle IN('" . implode('\',\'', $gtitlearray) . "')
			AND optioncode != 'hidden'
			AND varname NOT IN('portal_threadids')
	");
	while ($oldsetting = $db->fetch_array($oldsettings))
	{
		$adv_setting[$oldsetting['grouptitle']][$oldsetting['varname']] = $oldsetting;
	}

	// Module settings
	if (!empty($setting))
	{
		$lcount = 0;

		foreach ($adv_setting AS $grouptitle => $settings)
		{
			foreach ($settings AS $varname => $value)
			{
				$value = $setting[$grouptitle][$varname];

				switch ($varname)
				{
					// Additional site navigation pages
					case 'portal_navigation_addpages':
						$value = serialize(format_sitenav_links($value));
					break;

					// Layout
					case 'portal_column_array':

						$oldcolumns = unserialize($adv_setting[$grouptitle][$varname]['value']);
						$oldcolvars = array_values($oldcolumns);

						$oldphrases = fetch_column_phrases($oldcolvars);

						$columns = array();
						$newphrases = array();
						if (!empty($value))
						{
							foreach ($value AS $colkey => $colvals)
							{
								if (!$colvals['varname'])
								{
									continue;
								}

								$colvals['varname'] = trim($colvals['varname']);
								$colvals['title'] = trim($colvals['title']);

								$columns[$colkey] = $colvals['varname'];

								// Phrase
								if ($oldphrases[$colvals['varname'] . '_column'] != $colvals['title'])
								{
									$newphrases[$colvals['varname']] = $colvals['title'];
								}
							}
						}

						$value = serialize($columns);

						if (!empty($newphrases))
						{
							foreach ($newphrases AS $nphrase => $ntext)
							{
								// Insert first, just to make sure it's really there
								$db->query_write("
									INSERT IGNORE INTO " . TABLE_PREFIX . "phrase
										(languageid, varname, text, fieldname, product, username, dateline, version)
									VALUES (
										0,
										'" . $nphrase . "_column',
										'" . $db->escape_string($ntext) ."',
										'adv_portal_cp',
										'adv_cmps',
										'" . $db->escape_string($vbulletin->userinfo['username']) . "',
										" . TIMENOW . ",
										'$vba_options[portal_version]'
								)");

								$db->query_write("
									UPDATE " . TABLE_PREFIX . "phrase SET
										text = '" . $db->escape_string($ntext) ."',
										dateline = " . TIMENOW . ",
										version = '$vba_options[portal_version]',
										username = '" . $db->escape_string($vbulletin->userinfo['username']) . "'
									WHERE varname = '" . $nphrase . "_column'
										AND fieldname = 'adv_portal_cp'
										AND product = 'adv_cmps'
										AND languageid = 0
								");
							}

							require_once(DIR . '/includes/adminfunctions_language.php');
							build_language(0);
						}

					break;

					case 'portal_calendar_birthdays':
					case 'portal_calendarid':
						if ($value != $adv_setting[$grouptitle][$varname]['value'])
						{
							build_datastore('adv_portal_cale', '', 1);
						}
					break;

					default:

						if (is_array($value) OR $settings['serialize'])
						{
							$value = serialize($value);
						}
				}

				($hook = vBulletinHook::fetch_hook('vba_cmps_construct_cmps_settings')) ? eval($hook) : false;

				$db->query_write("
					UPDATE " . TABLE_PREFIX . "adv_setting SET
						value = '" . $db->escape_string($value) . "'
					WHERE varname = '$varname'
						AND grouptitle = '$grouptitle'
				");
			}
		}
		build_adv_settings();
	}

}

// ##### Format Site Navigation Module Links ##################################
function format_sitenav_links($value)
{
	if (!$value OR !is_array($value))
	{
		return array();
	}

	$pagelinks = array();
	foreach ($value AS $key => $array)
	{
		if ($array['text'])
		{
			foreach ($array AS $akey => $avalue)
			{
				$pagelinks[$key][$akey] = $avalue;
			}
		}
	}

	($hook = vBulletinHook::fetch_hook('vba_cmps_format_sitenav_links')) ? eval($hook) : false;

	usort($pagelinks, 'order_nav');
	return $pagelinks;
}

// ##### Construct Pages ######################################################
function construct_page_structure($pageinfo, $parent = 0)
{
	global $pagecounter;

	if (empty($pageinfo))
	{
		return array();
	}

	$pagearray = array();
	foreach ($pageinfo AS $pageid => $page)
	{
		if ($page['parentid'] == $parent)
		{
			$pagecounter++;
			$page['level'] = $pagecounter;
			$pagearray[$pageid] = $page;

			if ($subpage = construct_page_structure($pageinfo, $pageid))
			{
				$pagearray[$pageid]['hassubs'] = true;
				foreach ($subpage AS $thispageid => $values)
				{
					$subpageid = $thispageid;
					$pagearray[$subpageid] = $subpage[$subpageid];
				}
			}
			$pagecounter--;
		}
	}

	return $pagearray;
}

// ##### Cache CMPS Pages #####################################################
function cache_cmps_pages()
{
	global $db;

	$pagecache = array();
	$pages = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "adv_pages ORDER BY displayorder");
	while ($page = $db->fetch_array($pages))
	{
		$pagecache[$page['pageid']] = $page;
	}
	$db->free_result($pages);
	unset($page);

	$pagecache = construct_page_structure($pagecache, 0);

	return $pagecache;
}

// ##### Cache CMPS Modules ###################################################
// Cache the modules since $vb->adv_modules doesn't include inactive ones
function cache_cmps_modules()
{
	global $db;

	$modulecache = array();
	$getmodules = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "adv_modules ORDER BY title, modid");
	while ($mods = $db->fetch_array($getmodules))
	{
		$modulecache[$mods['modid']] = $mods;
	}

	return $modulecache;
}

// ############################ Fetch Page Data ###############################
function fetch_page_data($table, $perpage = 50)
{
	global $db, $vba_options, $condition, $wherequery, $vbulletin;

	if (!empty($wherequery))
	{
		$querywhere = 'WHERE ' . implode(' AND ', $wherequery);
	}

	$pagedata = $db->query_first("
		SELECT COUNT(*) AS count
		FROM " . TABLE_PREFIX . $table . "
		" . iif($condition['join'], 'LEFT JOIN ' . TABLE_PREFIX . $condition['join'] . ' USING (' . $condition['joinusing'] . ')'). "
		" . $querywhere
	);

	$pagedata['pagenumber'] = intval($_REQUEST['page']);

	// Work out pages & limits
	if (!$pagedata['pagenumber'])
	{
		$pagedata['pagenumber'] = 1;
	}

	$pagedata['perpage'] = $perpage;

	$pagedata['minlimit'] = intval(($pagedata['pagenumber'] - 1) * $pagedata['perpage'] + 1);
	$pagedata['maxlimit'] = intval($pagedata['pagenumber'] * $pagedata['perpage']);

	if ($pagedata['maxlimit'] > $pagedata['count'])
	{
		$pagedata['maxlimit'] = $pagedata['count'];
		if ($pagedata['minlimit'] > $pagedata['count'])
		{
			$pagedata['minlimit'] = $pagedata['count'] - $pagedata['perpage'];
		}
	}
	if ($pagedata['minlimit'] <= 0)
	{
		$pagedata['minlimit'] = 1;
	}

	$pagedata['pagecount'] = ceil($pagedata['count'] / $pagedata['perpage']);

	return $pagedata;
}

// ##### Fetch threadids ######################################################
function fetch_module_threadids($identifier)
{
	global $db;

	$set = $db->query_first("
		SELECT value
		FROM " . TABLE_PREFIX . "adv_setting
		WHERE grouptitle = 'adv_portal_$identifier'
			AND varname = 'portal_threadids'
	");

	$set['value'] = unserialize($set['value']);

	return (is_array($set['value'])) ? $set['value'] : array();
}

// ##### Format Module Layout #################################################
function format_module_layout($modpos, $removemods)
{
	global $vba_modcols;

	$modarray = array_diff(array_keys($modpos), $removemods);

	$layout = array();
	$colnames = array();
	foreach ($vba_modcols AS $colid => $colname)
	{
		$layout[$colid] = array();
		$colnames[] = $colid;
	}

	if (!empty($modarray))
	{
		foreach ($modarray AS $modid)
		{
			$mod =& $modpos[$modid];
			// Check that the values are valid
			if (in_array($mod['col'], $colnames))
			{
				$layout[$mod['col']][$modid] = intval($mod['order']);
			}
		}
	}

	if (!empty($layout))
	{
		foreach ($layout AS $column => $mods)
		{
			asort($layout[$column], SORT_NUMERIC);
		}
	}

	($hook = vBulletinHook::fetch_hook('vba_cmps_format_module_layout')) ? eval($hook) : false;

	return $layout;
}

// ##### Print Middle Submit Row ##############################################
function print_middle_submit_row($phrase = '', $colspan = 2, $previewtype = false, $reset = false, $align = 'right')
{
	global $stylevar, $vbphrase;

	if (!$phrase)
	{
		$phrase = $vbphrase['save'];
	}

	print_description_row(
		'<span ' . iif($align != 'center', 'style="float:' . $stylevar[$align] . '"') . '>
			<input type="submit" value="  ' . $phrase . '  " class="button" tabindex="1" />' .
		iif ($reset,
			' <input type="reset" class="button" name="reset" value=" ' . $vbphrase['reset'] . ' " />'
		) . '</span>' .
		iif ($previewtype,
			'<div><input type="button" class="button" name="preview" value="  ' . $vbphrase['preview'] . '  " onclick="preview_bbcode(\'' . $previewtype . '\');" tabindex="1" />'
		) .
		'</div>',
		false, $colspan, 'tfoot', iif($align == 'center', 'center')
	);
}

// ###### Fetch Page Select Array #############################################
function fetch_page_select_array($mainphrase = false)
{
	global $pagecache;

	if (empty($pagecache))
	{
		$pagecache = cache_cmps_pages();
	}

	if (empty($pagecache))
	{
		return;
	}

	$pageselect = array();
	foreach ($pagecache AS $pageid => $pageinfo)
	{
		$pageselect[$pageid] = str_repeat('--', ($pageinfo['level'] - 1)) . fetch_trimmed_title($pageinfo['title'], 40);
	}

	if ($mainphrase)
	{
		return array(0 => $mainphrase, '--------' => $pageselect);
	}
	else
	{
		return $pageselect;
	}
}

// ##### Print Current Integration Rows #######################################
function print_current_integration_row($varname, $selectopts = false)
{
	global $integratephrase, $vbphrase, $integopt;
	if (empty($integopt[$varname]))
	{
		return;
	}

	print_description_row($vbphrase[$integratephrase[$varname]], false, 3, 'thead');
	foreach ($integopt[$varname] AS $intfile => $intpage)
	{
		$selectopts = print_integration_page_select($intpage, 'name', $vbphrase['remove'], $exclude);

		print_cells_row(array(
			$intfile,
			'===>',
			'<select name="' . $varname . '_data[' . $intfile . ']" style="font-weight:bold" class="bginput" tabindex="1">'
				. $selectopts .
			'</select>'
		));
	}
}

// ##### Process Integration Data #############################################
function process_integration_data($gpcname, $name)
{
	global $vbulletin, $vba_options, $pluginarray;

	$minusdata = substr($gpcname, 0, (strlen($gpcname) - 5));

	$current = $vba_options['portal_integrate'][$minusdata];

	if (empty($vbulletin->GPC[$gpcname]) AND empty($current))
	{
		return;
	}

	$vbulletin->GPC[$gpcname] = array_merge($current, $vbulletin->GPC[$gpcname]);

	foreach ($vbulletin->GPC[$gpcname] AS $filename => $pagevar)
	{
		if (!$pagevar)
		{
			if ($_POST['do'] == 'dointegrate')
			{
				print_stop_message('adv_portal_must_select_file_integrate');
			}
			unset($vbulletin->GPC[$gpcname][$filename]);
		}
		else
		{
			$pluginarray[$name][$pagevar][] = $filename;
		}
	}
}

// ##### Print Integration Page Select ########################################
function print_integration_page_select($selected, $checkvar = 'pageid', $selectphrase = false, $exclude = array())
{
	global $vbulletin, $vbphrase, $pagecache, $cusmod;
	global $validpages;

	if (empty($pagecache))
	{
		$pagecache = cache_cmps_pages();
	}

	// Remove excluded pages
	if (!empty($exclude))
	{
		$pageids = array_diff(array_keys($pagecache), $exclude);
	}
	else
	{
		$pageids = array_keys($pagecache);
	}

	if (empty($cusmod))
	{
		$cusmod = $vbulletin->db->query_first("SELECT modid FROM " . TABLE_PREFIX . "adv_modules WHERE identifier = 'custompage'");
	}

	$validpages = array();

	$pageselect = '<option value="0">' . ($selectphrase ? $selectphrase : $vbphrase['please_select_a_page']) . '</option>
		<optgroup label="----------">
	';
	foreach ($pageids AS $pagekey => $pageid)
	{
		$pageinfo = $pagecache[$pageid];
		$pageinfo['modules'] = unserialize($pageinfo['modules']);

		$hascustom = false;

		if ($pageinfo['type'] == 'module' AND !empty($pageinfo['modules']))
		{
			foreach ($pageinfo['modules'] AS $modcol => $modlist)
			{
				if (in_array($cusmod['modid'], array_keys($modlist)))
				{
					$hascustom = true;
				}
			}
		}

		if ($hascustom)
		{
			$validpages[] = $pageinfo['pageid'];
			$pageselect .= '<option value="' . ($checkvar == 'pageid' ? $pageinfo['pageid'] : $pageinfo['name']) . '"' . iif($selected AND $selected == $pageinfo[$checkvar], ' selected="selected"') . '>' . str_repeat('--', ($pageinfo['level'] - 1)) . fetch_trimmed_title($pageinfo['title'], 40) . '</option>';
		}
		else
		{
			$pageselect .= '<optgroup style="color: #9EA0A2" label="' . str_repeat('--', ($pageinfo['level'] - 1)) . fetch_trimmed_title($pageinfo['title'], 40) . '"></optgroup>';
		}
	}

	$pageselect .= '</optgroup>';

	return $pageselect;
}

// ##### Process Deleted Integration ##########################################
function process_deleted_integration($type, $identifier = false)
{
	global $vbulletin, $integopt;

	if (!empty($vbulletin->GPC[$type . '_data']))
	{
		foreach ($vbulletin->GPC[$type . '_data'] AS $ifilename => $ipageid)
		{
			if ($ipageid AND $ipageid != $identifier)
			{
				$integopt[$type][$ifilename] = $ipageid;
			}
			else
			{
				unset($integopt[$type][$ifilename]);
			}
		}
	}
}

// ###### Build Integration Plugin ############################################
function build_integration_plugin()
{
	global $vbulletin, $vba_options, $pluginarray;

	$vbulletin->input->clean_array_gpc('p', array(
		'vba_page' => TYPE_INT,
		'vbfilenames_data' => TYPE_ARRAY,
		'otfilenames_data' => TYPE_ARRAY,
		'thisscript_data' => TYPE_ARRAY
	));

	$pluginarray = array();

	// Process the data
	process_integration_data('vbfilenames_data', 'files');
	process_integration_data('otfilenames_data', 'files');
	process_integration_data('thisscript_data', 'thisscript');

	$no_ajax_spacing = false;
	$pluginoutput = '';

	// Format the filenames
	if (!empty($pluginarray['files']) OR !empty($pluginarray['thisscript']))
	{
		$pluginoutput = 'if (THIS_SCRIPT != \'adv_index\' AND VB_AREA == \'Forum\')' . "\r\n{\r\n";
	}

	if (!empty($pluginarray['files']))
	{
		$pluginoutput .= "\t" . '$this_filename = substr($_SERVER[\'PHP_SELF\'], (strrpos($_SERVER[\'PHP_SELF\'], \'/\') + 1));' . "\r\n\tswitch (" . '$this_filename' . ")\r\n\t{";

		foreach ($pluginarray['files'] AS $pagename => $pagevalues)
		{
			if (!empty($pagevalues))
			{
				$pluginoutput .= "\r\n\t\t";
				$pluginoutput .= 'case \'' . implode("':\r\n\t\t" . "case '", $pagevalues) . '\':';
				$pluginoutput .= "\r\n\t\t\tdefine('VBA_PORTAL', true);\r\n\t\t\tdefine('VBA_PAGE', '$pagename');\r\n\t\tbreak;\r\n";

				if (in_array('showthread.php', $pagevalues))
				{
					$no_ajax_spacing = true;
				}
			}
		}
		$pluginoutput .= "\t}\r\n";
	}

	// Format THIS_SCRIPT values
	if (!empty($pluginarray['thisscript']))
	{
		$pluginoutput .= "\r\n\tswitch (THIS_SCRIPT)\r\n\t{";

		foreach ($pluginarray['thisscript'] AS $pagename => $pagevalues)
		{
			if (!empty($pagevalues))
			{
				$pluginoutput .= "\r\n\t\t";
				$pluginoutput .= 'case \'' . implode("':\r\n\t\t" . "case '", $pagevalues) . '\':';
				$pluginoutput .= "\r\n\t\t\tdefine('VBA_PORTAL', true);\r\n\t\t\tdefine('VBA_PAGE', '$pagename');\r\n\t\tbreak;\r\n";

				if (in_array('SHOWTHREAD', $pagevalues))
				{
					$no_ajax_spacing = true;
				}

			}
		}
		$pluginoutput .= "\t}\r\n";
	}

	if ($pluginoutput)
	{
		$pluginoutput .= "\r\n\tif (defined('VBA_PORTAL'))\r\n\t{\r\n\t\trequire_once(DIR . '/includes/vba_cmps_include_template.php');\r\n\t\t";
		$pluginoutput .= 'foreach ($specialtemplates AS $stempname)' . "\r\n\t\t{\r\n\t\t\t";
		$pluginoutput .= 'if (!isset($vbulletin->datastore->registry->$stempname)) { $datastore_fetch[] = "\'$stempname\'"; }' . "\r\n\t\t}\r\n\t}";

		if ($no_ajax_spacing)
		{
			$pluginoutput .= "\r\n\tdefine('NO_AJAX_SPACING', true);";
		}

		$pluginoutput .= "\r\n}";
	}

	($hook = vBulletinHook::fetch_hook('vba_cmps_admin_integrate_pluginoutput')) ? eval($hook) : false;

	// Update the plugin
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "plugin SET
			phpcode = '" . $vbulletin->db->escape_string($pluginoutput) . "'
		WHERE devkey = 'adv_cmps_integrate_start'
			AND product = 'adv_cmps'
	");

	vBulletinHook::build_datastore($vbulletin->db);

	$currentint =& $vba_options['portal_integrate'];

	ksort($vbulletin->GPC['vbfilenames_data']);
	ksort($vbulletin->GPC['otfilenames_data']);
	ksort($vbulletin->GPC['thisscript_data']);

	// Update the setting
	$settingvalue = array(
		'vbfilenames' => $vbulletin->GPC['vbfilenames_data'],
		'otfilenames' => $vbulletin->GPC['otfilenames_data'],
		'thisscript' => $vbulletin->GPC['thisscript_data'],
		'vba_page' => $vbulletin->GPC['vba_page']
	);

	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "adv_setting SET
			value = '" . $vbulletin->db->escape_string(serialize($settingvalue)) . "'
		WHERE varname = 'portal_integrate'
	");

	build_adv_settings();
}

// ##### Print CP Text Editor #################################################
function print_cp_text_editor($type)
{
	global $vbulletin, $vbphrase, $stylevar, $style, $istyles, $show, $messagearea, $smiliebox, $disablesmiliesoption, $checked, $vBeditTemplate;
	global $page, $module, $modopts;

	($hook = vBulletinHook::fetch_hook('vba_cmps_cp_text_editor')) ? eval($hook) : false;

	if ($type == 'page')
	{
		$inputnames = 'setting[custompage]';
		$settings =& $page['advanced']['custompage'];
		$message =& $page['template'];
	}
	else
	{
		$inputnames = 'module[options]';
		$settings =& $modopts;
		$message = $module['filename'];
	}

	require_once(DIR . '/includes/functions_editor.php');
	$textareacols = fetch_textarea_width();

	$gettemp = $vbulletin->db->query_read("
		SELECT title, template
		FROM " . TABLE_PREFIX . "template
		WHERE title IN('editor_toolbar_on', 'editor_smilie', 'editor_clientscript','editor_toolbar_off', 'editor_jsoptions_font', 'editor_jsoptions_size','editor_smiliebox', 'editor_smiliebox_category', 'editor_smiliebox_row', 'editor_smiliebox_straggler', 'editor_css')
			AND styleid = '-1'
	");
	while ($temp = $vbulletin->db->fetch_array($gettemp))
	{
		$vbulletin->templatecache[$temp['title']] = $temp['template'];
	}

	$style = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "style WHERE styleid = " . $vbulletin->options['styleid']);

	$stylevar = array_merge(unserialize($style['stylevars']), $stylevar);
	$stycolor = unserialize($style['csscolors']);
	$istyles = unserialize($style['editorstyles']);

	// Replace custom BB code images
	if (!empty($vbulletin->bbcodecache))
	{
		foreach ($vbulletin->bbcodecache AS $bbcodeid => $bbcodeinfo)
		{
			if ($bbcodeinfo['buttonimage'])
			{
				$vbulletin->bbcodecache[$bbcodeid]['buttonimage'] = $vbulletin->options['bburl'] . '/' . $bbcodeinfo['buttonimage'];
			}
		}
	}

	// CSS For vB 3.7
	if (IS_VB_37)
	{
		eval('$editor_css = "' . fetch_template('editor_css') . '";');

		echo str_replace('"clientscript', '"' . $vbulletin->options['bburl'] . '/clientscript', $editor_css);
	}

	echo '<style type="text/css"><!--
		.wysiwyg
		{
			background-color: ' . $stycolor['wysiwyg_bgcolor'] . ';
			color: ' . $stycolor['wysiwyg_fgcolor'] . ';
			font: 10pt verdana, geneva, lucida, \'lucida grande\', arial, helvetica, sans-serif;
		}
	-->
	</style>
	<script type="text/javascript">
	<!--
		var is_ie7 = false;
		YAHOO.env.ua.ie = false;
	-->
	</script>';

	// Editor & message area
	$vbulletin->options['allowbbcode'] = 1;
	$vbulletin->options['allowbbimagecode'] = $settings['allow_image_code'];

	construct_edit_toolbar(htmlspecialchars($message), false, 'nonforum', true, $settings['allow_smilies']);

	print_description_row('<div style="padding-top: 5px">' . $vbphrase[$type] . ' ' . $vbphrase['content'] . ':</div>' . str_replace('"clientscript', '"' . $vbulletin->options['bburl'] . '/clientscript', process_replacement_vars($messagearea)));

	print_checkbox_row($vbphrase['allow_html'], $inputnames . '[allow_html]', $settings['allow_html']);
	print_checkbox_row($vbphrase['allow_smilies'], $inputnames . '[allow_smilies]', $settings['allow_smilies']);
	print_checkbox_row($vbphrase['allow_image_code'], $inputnames . '[allow_image_code]', $settings['allow_image_code']);

	define('CP_TEXT_EDITOR', true);
}

// ##### Print Template Box ###################################################
function print_new_template_box()
{
	global $vbphrase, $stylecache;

	if ($_REQUEST['do'] == 'addmodule' OR $_REQUEST['do'] == 'addpage')
	{
		$type = ($_REQUEST['do'] == 'addmodule') ? 'module' : 'page';

		cache_styles();

		$stylesel = array();
		foreach ($stylecache AS $cstyleid => $cstyle)
		{
			$stylesel[$cstyleid] = construct_depth_mark($cstyle['depth'], '--') . $cstyle['title'];
		}

		print_select_row(
			$vbphrase['style'] . '<div class="smallfont">' . $vbphrase['select_style_add_template_to'] . '</div>',
			'thisstyleid[]',
			$stylesel,
			'',
			false,
			(sizeof($stylecache) <= 6 ? sizeof($stylecache) : 6),
			true
		);
		print_textarea_row(construct_phrase($vbphrase['template_content'], $vbphrase[$type]), 'template', '', 12, 32, true, true, 'ltr', 'code');
	}
}

// ##### Insert New Templates #################################################
function insert_new_cmps_templates($name)
{
	global $vbulletin, $db;

	// Globalize variables from the build_all_styles() function
	global $_query_special_templates, $template_cache;

	$thisstyleid = $vbulletin->GPC['thisstyleid'];
	$template = $vbulletin->GPC['template'];

	if (!trim($template))
	{
		return false;
	}

	if (empty($thisstyleid))
	{
		print_stop_message('adv_portal_choose_style');
	}

	if ($checkexist = $db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "template
		WHERE title = '" . $db->escape_string($name) . "'
			AND styleid IN(" . implode(', ', $thisstyleid) . ")
	"))
	{
		print_stop_message('adv_portal_template_exists', $name);
	}

	require_once(DIR . '/includes/adminfunctions_template.php');

	$templateinsert = '';

	if (!empty($thisstyleid))
	{
		foreach ($thisstyleid AS $installstyleid)
		{
			$templateinsert .= "(
				'" . $db->escape_string($name) . "',
				'" . $db->escape_string(compile_template($template)) . "',
				'" . $db->escape_string($template) ."',
				'$installstyleid',
				'template',
				" . TIMENOW . ",
				'" . $db->escape_string($vbulletin->userinfo['username']) . "',
				'" . $vbulletin->options['templateversion'] . "',
				'adv_cmps'
			),";
		}

		$db->query_write("
			INSERT INTO " . TABLE_PREFIX . "template
				(title, template, template_un, styleid, templatetype, dateline, username, version, product)
			VALUES
				" . substr($templateinsert, 0, (strlen($templateinsert) - 1))
		);
	}

	build_all_styles();
}

// ##### Check for duplicate identifiers ######################################
function fetch_copied_identifier($identifier)
{
	global $db;
	
	$modarray = array();
	$getmods = $db->query_read("
		SELECT identifier
		FROM " . TABLE_PREFIX . "adv_modules
		WHERE identifier LIKE '" . $db->escape_string($identifier) . "%'
	");
	while ($mod = $db->fetch_array($getmods))
	{
		$modarray[] = $mod['identifier'];
	}

	if (!in_array($identifier, $modarray))
	{
		return $identifier;
	}

	$count = 1;
	while ($count <= sizeof($modarray) + 1)
	{
		$count++;
		if (!in_array($identifier . $count, $modarray))
		{
			return $identifier . $count;
		}
	}
}

// ##### Get Dynamics Instances ###############################################
function get_dynamics_instances()
{
	global $db;
	
	$groups = array();
	$settings = $db->query_read("
		SELECT grouptitle, value
		FROM " . TABLE_PREFIX . "adv_setting
		WHERE varname = 'dyna_version'
	");
	while ($setting = $db->fetch_array($settings))
	{
		if (version_compare($setting['value'], '1.2', '>'))
		{
			$groups[] = $setting['grouptitle'];
		}
	}

	return $groups;
}

// ##### Check File Path ######################################################
function check_cmps_file_path($path)
{
	if (substr($path, 0, 1) == '/')
	{
		$path = $_SERVER['DOCUMENT_ROOT'] . $path;
	}

	if (@fopen($path, 'r'))
	{
		return true;
	}
	
	if (@file_get_contents($path))
	{
		return true;
	}
	
	return false;
}

// ##### Fetch Page Integration Status ########################################
function fetch_page_integration_status($page)
{
	$integopt =& $vba_options['portal_integrate'];

	if (!empty($integopt))
	{
		foreach ($integopt AS $inttype => $integration)
		{
			if (is_array($integration))
			{
				if (in_array($page['name'], array_values($integration)))
				{
					$integrated = true;
				}
			}
		}
	}
}

?>